#ifndef IMAGE_GUARD
#define IMAGE_GUARD

#include "afmm/include/field.h"



class Image{
	private:
        /** VARIABLES **/
	unsigned int    islandThreshold;
        float           layerThreshold;
        float          *importance;
        int             numLayers;
        int             nPix; /* Short for (dimX * dimY) */
        

	
	public:
        /** VARIABLES **/
        FIELD<float>   *im;

        /** CONSTRUCTORS **/
        Image(FIELD<float> *in);
	Image(FIELD<float> *in, unsigned int islandThresh, float importanceThresh);

        /** DESTRUCTOR **/
        ~Image();

        /** FUNCTIONS **/
        static void removeIslands(FIELD<float>*layer, unsigned int iThresh);
	void removeIslands();
        void removeLayers();
	void calculateImportance();
        void computeSkeletons();
        void removeDuplicatePoints(FIELD<float> *imPrev, FIELD<float> *skP, FIELD<float> *imCur, FIELD<float> *skC);


};

#endif
